---
title: Set up Authenticated Origin Pulls · Cloudflare SSL/TLS docs
description: Refer to the following sections to learn how to manage certificates
  used with the different Authenticated Origin Pulls setups.
lastUpdated: 2025-07-10T07:26:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/set-up/manage-certificates/
  md: https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/set-up/manage-certificates/index.md
---

Refer to the following sections to learn how to manage certificates used with the different Authenticated Origin Pulls setups.

## Use specialized certificates

To apply different client certificates simultaneously at both the zone and hostname level, you can combine zone-level and per-hostname custom certificates.

First set up [zone-level pulls](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/set-up/zone-level/) using a certificate. Then, upload multiple, specialized certificates for [individual hostnames](https://developers.cloudflare.com/ssl/origin-configuration/authenticated-origin-pull/set-up/per-hostname/).

Note

Since per-hostname certificates are more specific, they take precedence over zone certificates.

## Delete a certificate

Client certificates are not deleted from Cloudflare upon expiration unless a [delete](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/methods/delete/) or [replace](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/methods/create/) request is sent to the Cloudflare API.

However, requests are dropped at your origin if your origin only accepts a valid client certificate.

## Replace a client cert (without downtime)

### Per-hostname

1. [Upload the new certificate](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/subresources/hostnames/subresources/certificates/methods/create/).
2. [List your certificates](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/subresources/hostnames/subresources/certificates/methods/list/) and note the ID for the certificate you uploaded.
3. [Enable Authenticated Origin Pulls for the specific hostname](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/subresources/hostnames/methods/update/), using the ID obtained in step 2 to specify the certificate you want to use:

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `SSL and Certificates Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/origin_tls_client_auth/hostnames" \
  --request PUT \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY" \
  --json '{
    "config": [
        {
            "enabled": true,
            "hostname": "<HOSTNAME>",
            "cert_id": "<CERT_ID>"
        }
    ]
  }'
```

### Zone-level

1. [Upload the new certificate](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/methods/create/).
2. [Check whether new certificate is Active](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/methods/get/).
3. Once certificate is active, [delete the previous certificate](https://developers.cloudflare.com/api/resources/origin_tls_client_auth/methods/delete/).

Note

If you keep both certificates, the API will state `active` for both but the most recently deployed certificate will be the one enabled and used.
