---
title: Debugging · Cloudflare Workers docs
description: Debug your Workers tests with Vitest.
lastUpdated: 2025-03-04T10:04:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/testing/vitest-integration/debugging/
  md: https://developers.cloudflare.com/workers/testing/vitest-integration/debugging/index.md
---

This guide shows you how to debug your Workers tests with Vitest. This is available with `@cloudflare/vitest-pool-workers` v0.7.5 or later.

## Open inspector with Vitest

To start debugging, run Vitest with the following command and attach a debugger to port `9229`:

```sh
vitest --inspect --no-file-parallelism
```

## Customize the inspector port

By default, the inspector will be opened on port `9229`. If you need to use a different port (for example, `3456`), you can run the following command:

```sh
vitest --inspect=3456 --no-file-parallelism
```

Alternatively, you can define it in your Vitest configuration file:

```ts
import { defineWorkersConfig } from "@cloudflare/vitest-pool-workers/config";


export default defineWorkersConfig({
  test: {
    inspector: {
        port: 3456,
    },
    poolOptions: {
      workers: {
        // ...
      },
    },
  },
});
```

## Setup VS Code to use breakpoints

To setup VS Code for breakpoint debugging in your Worker tests, create a `.vscode/launch.json` file that contains the following configuration:

```json
{
    "configurations": [
        {
            "type": "node",
            "request": "launch",
            "name": "Open inspector with Vitest",
            "program": "${workspaceRoot}/node_modules/vitest/vitest.mjs",
            "console": "integratedTerminal",
            "args": ["--inspect=9229", "--no-file-parallelism"]
        },
        {
            "name": "Attach to Workers Runtime",
            "type": "node",
            "request": "attach",
            "port": 9229,
            "cwd": "/",
            "resolveSourceMapLocations": null,
            "attachExistingChildren": false,
            "autoAttachChildProcesses": false,
        }
    ],
    "compounds": [
        {
            "name": "Debug Workers tests",
            "configurations": ["Open inspector with Vitest", "Attach to Workers Runtime"],
            "stopAll": true
        }
    ]
}
```

Select **Debug Workers tests** at the top of the **Run & Debug** panel to open an inspector with Vitest and attach a debugger to the Workers runtime. Then you can add breakpoints to your test files and start debugging.
